//
//  GameScene.swift
//  SpriteKitShaderDemo
//
//  Created by Simon Voelker on 10/12/15.
//  Copyright (c) 2015 i10. All rights reserved.
//

import SpriteKit
import GLKit

class GameScene: SKScene {
    
    
    override func didMoveToView(view: SKView) {
        /* Setup your scene here */
        let myLabel = SKLabelNode(fontNamed:"Chalkduster")
        myLabel.text = "Hello, World!"
        myLabel.fontSize = 45
        myLabel.position = CGPoint(x:CGRectGetMidX(self.frame), y:CGRectGetMidY(self.frame))
        
        
        // Create Sprite
        let sprite = SKSpriteNode(color: UIColor.redColor(), size: CGSizeMake(400, 400))
        
        sprite.position = CGPoint(x:CGRectGetMidX(self.frame)-200, y:CGRectGetMidY(self.frame)-200)
        sprite.anchorPoint = CGPointMake(0, 0)
        
        sprite.name = "Sprite"
        
        self.addChild(sprite)
        
        
        //Load Shader and set Uniform
        
        sprite.shader = SKShader(fileNamed: "Shader.fsh")
        sprite.shader?.addUniform(SKUniform(name: "pos", floatVector2: GLKVector2(v: (0.5,0.5))))
        
        
        self.addChild(myLabel)
    }
    
    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
       /* Called when a touch begins */
        
        for touch in touches {
            let sprite = self.childNodeWithName("Sprite") as! SKSpriteNode
            if((sprite.containsPoint(touch.locationInNode(self))) != false)
            {
                let uniform = sprite.shader?.uniformNamed("pos")
                let localPosition = touch.locationInNode(sprite)
                
                 uniform?.floatVector2Value = GLKVector2(v: ( Float(localPosition.x) / Float(sprite.size.width), Float(localPosition.y) / Float(sprite.size.height)))
    
                
            }
            
            
        
        }
    }
   
    override func update(currentTime: CFTimeInterval) {
        /* Called before each frame is rendered */
    }
}
